% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_nugget.R
\name{optimize_nugget}
\alias{optimize_nugget}
\title{Find the maximum likelihood estimate of the nugget}
\usage{
optimize_nugget(
  X,
  y,
  V,
  lower = 0.001,
  upper = 0.999,
  tol = .Machine$double.eps^0.25,
  debug = FALSE,
  ncores = NA
)
}
\arguments{
\item{X}{numeric (double) nxp matrix}

\item{y}{numeric (double) nx1 column vector}

\item{V}{numeric (double) nxn matrix}

\item{lower}{lower boundary for nugget search}

\item{upper}{upper boundary for nugget search}

\item{tol}{desired accuracy of nugget search}

\item{debug}{logical: debug mode?}

\item{ncores}{an optional integer indicating how many CPU threads to use for
matrix calculations.}
}
\value{
maximum likelihood nugget estimate
}
\description{
Find the maximum likelihood estimate of the nugget
}
\details{
Finds the maximum likelihood nugget estimate via mathematical
optimization.

To maximize efficiency, \code{optimize_nugget()} is implemented entirely
in C++. Optimization takes place via a C++ version of the \code{fmin} routine
(Forsythe et al 1977). Translated from http://www.netlib.org/fmm/fmin.f

The function \code{LogLikGLS()} is optimized for \code{nugget}. Once the
\code{LogLikGLS()} functionality is absorbed by \code{fitGLS()}, it will
be used instead.
}
\seealso{
\code{?stats::optimize()}
}
