% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoWeight.R
\name{geoWeight}
\alias{geoWeight}
\title{Geographic weighting}
\usage{
geoWeight(x, f = function(x) cos(x), ...)
}
\arguments{
\item{x}{a Raster* object}

\item{f}{a function to be used to the weighting.
Defaults to \code{cos(x)}}

\item{...}{additional arguments to be passed to f}
}
\value{
a weighted Raster* object
}
\description{
The function performs geographic weighting of non-projected long/lat
data. By default it uses the cosine of latitude to compensate for the
area distortion, though the user can supply other functions via \code{f}.
}
\examples{
data(vdendool)

wgtd <- geoWeight(vdendool)

opar <- par(mfrow = c(1,2))
plot(vdendool[[1]], main = "original")
plot(wgtd[[1]], main = "weighted")
par(opar)
}
