% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectsTie.R
\name{dyad}
\alias{dyad}
\title{dyad}
\usage{
dyad(param = NULL, variable, attr_dyads, scaling = c("none", "std"))
}
\arguments{
\item{param}{numeric value, data.frame  or function with time parameter. Specifies the value of the effect for the statistic in the REM model}

\item{variable}{character vector specifies the name of the column with covariate value in attr_actors data.frame}

\item{attr_dyads}{data.frame object with rows specifying values of attr_dyads for a pair of actors (dyad). First column must contain sender id, Second column receiver id, Third column contains values for the attributes with column name corresponding to variable name}

\item{scaling}{specifies the method for scaling the statistic. \code{"none"} [default] gives raw value of the statistic at time t, \code{"std"} the statistic is standardized per time}
}
\value{
List with all information required by `remulate::remulateTie()` or 'remulate::remulateActor()' to compute the statistic.
}
\description{
This function specifies the input for the dyad effect in the \code{formula} argument for the function \code{\link{remulateTie}} or \code{\link{remulateActor}}. Not to be used independently
}
\details{
Dyadic covariate: dyad attribute value is the tendency to create an event i -> j when (i,j) has a high attribute value.



if param is a data frame, it must have three columns: sender, receiver, and value (numeric), 
representing the parameter value for thay dyadic pair. The data.frame must contain 
all pairs of actors or dyads corresponding to the riskset. 

if param is a function, it's first argument must be 't', corresponding to the time. The
function may have additional arguments.
}
