% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiBi.R
\name{bibi}
\alias{bibi}
\title{Kinetic Mechanisms and Parameters for Bi-Bi Reactions}
\usage{
bibi(data, unit_a = "mM", unit_b = "mM", unit_v = "ua", vice_versa = FALSE)
}
\arguments{
\item{data}{either a dataframe or the path to a text file containing the data (see details).}

\item{unit_a}{concentration unit for substrate A.}

\item{unit_b}{concentration unit for substrate B.}

\item{unit_v}{velocity unit.}

\item{vice_versa}{logical. When FALSE the variable substrate is A. If TRUE, then the variable substrate is B.}
}
\value{
A list with three elements: (i) a character vector giving the kinetic parameters Vmax, KiA, Km_A and Km_B values; (ii) a numeric vector giving the apparent inverse of Vmax for each concentration of substrate B (intercepts of primary representation); and (iii) a numeric vector giving the apparent specificity constant for each concentration of substrate B (slopes from primary representations).
}
\description{
Discriminates between sequential and ping-pong mechanisms and estimates the kinetic parameters.
}
\details{
Either the txt file or the dataframe containing the data must conform to the following format: a table with three columns and as many rows as conditions were assessed. The first and second columns are named 'a' and 'b' and they give the concentrations for substrate A and B, respectively. The third column, named 'rate', provides the assessed rates.
}
\examples{
bibi(data = hk)
}
