% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_print}
\alias{repo_print}
\title{Show a summary of the repository contents.}
\usage{
repo_print(tags = NULL, tagfun = "OR", find = NULL, all = F, show = "ds")
}
\arguments{
\item{tags}{A list of character tags. Only items matching all the
tags will be shown.}

\item{tagfun}{How to combine tags (see Details).}

\item{find}{Character to match any filed (see Details).}

\item{all}{Show also items tagged with "hide".}

\item{show}{Select columns to show.}
}
\value{
Used for side effects.
}
\description{
Show a summary of the repository contents.
}
\details{
The \code{tagfun} param specifies how to combine multiple
tags when matching items. It can be either a character or a
function. As a character, it can be one of \code{OR}, \code{AND} or
\code{NOT} to specify that one, all or none of the tags must be
matched, respectively. If it is a function, it must take two tag
vectors, the first of which corresponds to \code{tags}, and return
TRUE for a match, FALSE otherwise.

The find param can be any character string to be matched against
any item field, including string-converted size (like "10x3").
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", c("tag1", "tag2"))
rp$put(2, "item2", "Sample item 2", c("tag1", "hide"))
rp$put(3, "item3", "Sample item 3", c("tag2", "tag3"))
rp$print()
rp$print(all=TRUE)
rp$print(show="tds", all=TRUE)
rp$print(show="tds", all=TRUE, tags="tag1")
## wiping the temp repo
unlink(rp_path, TRUE)

## wiping temporary repo
unlink(rp_path, TRUE)
}
