% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitran.R
\name{unitran}
\alias{unitran}
\alias{unitran_inv}
\alias{unitran_prime}
\title{Unified transformation}
\usage{
unitran(x, name=NULL, par=NULL, alpha=NULL, beta=NULL, reverse="auto")

unitran_inv(y, name=NULL, par=NULL, alpha=NULL, beta=NULL, reverse="auto")

unitran_prime(x, name=NULL, par=NULL, alpha=NULL, beta=NULL, reverse="auto")
}
\arguments{
\item{x, y}{Variable to be transformed, \code{x} must be between 0 and 1.}

\item{name}{Optional model name, case-insensitive, in quotes. One of \code{Richards},
\code{monomolecular}, \code{Mitscherlich}, \code{Bertalanffy}, \code{Gompertz},
\code{logistic}, \code{Levacovic}, \code{Weibull}, \code{Korf}, \code{exponential},
\code{Schumacher}, \code{Hosfeld}.}

\item{par}{Model parameter, if needed and model name supplied.}

\item{alpha, beta}{Shape parameters, if the model is not specified by name.}

\item{reverse}{Reverse \code{x} and \code{t} axes? One of \code{"yes"}, \code{"no"}, \code{"auto"}.
With \code{"auto"}, axes are reversed as necessary for an upper asymptote.
(i.e., if \code{alpha <= 0} and \code{beta > 0}).}
}
\value{
\code{unitran()}: Transformed \code{x}, i.e., \eqn{y = \varphi(x)}.

\code{unitran_inv()}: Inverse of \code{unitran()},  \eqn{x = \varphi^{-1}(y)}{x = \varphi^-1(y)}.

\code{unitran_prime()}: Derivative of \code{unitran()},  \eqn{y' = \varphi'(x)}.
}
\description{
Calculates a variable transformation that produces various growth curve models, depending on the
values of two shape parameters, \code{alpha} and \code{beta}. Models can also
be specified by name. Uses \code{\link{bc}(), bc_inv(), bc_prime()}.
}
\section{Functions}{
\itemize{
\item \code{unitran()}: Unified transformation.

\item \code{unitran_inv()}: Inverse of unitran().

\item \code{unitran_prime()}: Derivative of \code{unitran()} with respect to \code{x}.

}}
\examples{
curve(unitran(x, "Gompertz"))  # same as unitran(x, alpha=0, beta=0)
curve(unitran_inv(y, "logistic"), xname="y", from=-4, to=4)
curve(unitran_prime(x, "logistic"))
}
