% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_mixture.R
\name{dist_mixture}
\alias{dist_mixture}
\title{Mixture distribution}
\usage{
dist_mixture(dists = list(), probs = NULL)
}
\arguments{
\item{dists}{A list of mixing distributions.
May contain placeholders and duplicates.}

\item{probs}{A list of mixing probabilities with the same length as \code{dists}.
They are normalized to sum to one and \code{NULL} can be used as a placeholder
within probs.
To reduce the number of required parameters, probs should at least be partly
specified (\code{probs = list(NULL, NULL, ..., 1)} with k - 1 \code{NULL}s where k is
the number of mixing components).}
}
\value{
A \code{MixtureDistribution} object.
}
\description{
Parameters of mixing components can be overridden with
\code{with_params = list(dists = list(..., ..., ...))}.
#' Mixing probabilites can be overridden with
\code{with_params = list(probs = list(..., ..., ...))}.
The \strong{number of components} cannot be overridden.
}
\details{
Does \strong{not} support the \code{quantile()} capability!
}
\examples{

# A complicated way to define a uniform distribution on \[0, 2\]
dist_mixture(
  dists = list(
    dist_uniform(min = 0, max = 1),
    dist_uniform(min = 1, max = 2)
  ),
  probs = list(0.5, 0.5)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
