% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retentionmort_figure.R
\name{retentionmort_figure}
\alias{retentionmort_figure}
\title{Generate a .html markdown file of preliminary figures pertaining from either
the retenionmort() or retentionmort_generation() function.}
\usage{
retentionmort_figure(datacomp)
}
\arguments{
\item{datacomp}{The file generated from either the retentionmort() or
retentionmort_generation() functions.}
}
\value{
This function will return one markdown file named \code{retentionmort.html} in your
current working directory listing some helpful information for analyzing
model data generated from the retentionmort() or retentionmort_generation()
functions
}
\description{
By inputing the \code{datacomp} dataframe, this function will save a markdown file
in the working directory named \code{retentionmort.html}that provides helpful
information on the error associated with the number of recaptured individuals
compared to the expected number provided by the model. Some figures will be
less applicable for the field data application using the retentionmort()
function due to a low sample size, specifically figures 5 and 6.
}
\examples{

#Using retentionmort_generation() to produce multiple iterations of data to
#run the model through
   \donttest{
   datacomp = retentionmort_generation()
   Rmark = file.path(tempdir(),retentionmort_figure(datacomp))
   unlink("retentionmort.Rmd")
   unlink("retentionmort.html")
   }

#Creating a dataset with test_dataset_retentionmort() and running the
#retentionmort() function
   ret_env <- new.env()
   data<- test_dataset_retentionmort()
   list2env(data, envir = ret_env)
   datacomp = retentionmort(n_c1=ret_env$n_c1, nT=ret_env$nT,
                TaL=ret_env$TaL, c=ret_env$c, R=ret_env$R, err=ret_env$err)
#Creating the markdown on datacomp
   Rmark = file.path(tempdir(),retentionmort_figure(datacomp))
   unlink("retentionmort.Rmd")
   unlink("retentionmort.html")


}
