% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n-fold-manifold.R
\name{NFoldManifold}
\alias{NFoldManifold}
\title{Class for N-Fold Product Manifolds}
\description{
Class for an \eqn{n}-fold product manifold \eqn{M^n}. It defines
a manifold as the product manifold of \eqn{n} copies of a given base
manifold \eqn{M}.
}
\examples{

## ------------------------------------------------
## Method `NFoldManifold$new`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  nfm <- NFoldManifold$new(
    base_manifold = SPDMatrix(n = 3),
    n_copies = 3
  )
  nfm
}
}
\author{
Nicolas Guigui
}
\concept{product manifold}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{NFoldManifold}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NFoldManifold-new}{\code{NFoldManifold$new()}}
\item \href{#method-NFoldManifold-clone}{\code{NFoldManifold$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NFoldManifold-new"></a>}}
\if{latex}{\out{\hypertarget{method-NFoldManifold-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{NFoldManifold}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NFoldManifold$new(
  base_manifold,
  n_copies,
  metric = NULL,
  default_coords_type = "intrinsic",
  py_cls = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_manifold}}{An \link[R6:R6Class]{R6::R6Class} specifying the base manifold to
copy.}

\item{\code{n_copies}}{An integer value specifying the number of replication of
the base manifold.}

\item{\code{metric}}{An \link[R6:R6Class]{R6::R6Class} specifying the base metric to use.
Defaults to \code{NULL} which uses the Riemannian metric.}

\item{\code{default_coords_type}}{A string specifying the coordinate type.
Choices are \code{"intrinsic"} or \code{"extrinsic"}. Defaults to \code{"intrinsic"}.}

\item{\code{py_cls}}{A Python object of class \code{NFoldManifold}. Defaults to
\code{NULL} in which case it is instantiated on the fly using the other
input arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{NFoldManifold}} \link[R6:R6Class]{R6::R6Class} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  nfm <- NFoldManifold$new(
    base_manifold = SPDMatrix(n = 3),
    n_copies = 3
  )
  nfm
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NFoldManifold-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NFoldManifold-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NFoldManifold$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
