% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-orthogonal.R
\name{SpecialOrthogonal}
\alias{SpecialOrthogonal}
\title{Class for the Special Orthogonal Group}
\usage{
SpecialOrthogonal(n, point_type = "matrix", epsilon = 0, ..., py_cls = NULL)
}
\arguments{
\item{n}{An integer value representing the shape of the \verb{n x n} matrices.}

\item{point_type}{A character string specifying how elements of the group
should be represented. Choices are either \code{"vector"} or \code{"matrix"}.
Defaults to \code{"matrix"}.}

\item{epsilon}{A numeric value specifying the precision to use for
calculations involving potential division by 0 in rotations. Defaults to
\code{0.0}.}

\item{...}{Extra arguments to be passed to parent class constructors. See
\code{\link{LieGroup}}, \code{\link{MatrixLieAlgebra}}, \code{\link{LevelSet}} and \code{\link{Manifold}} classes.}

\item{py_cls}{A Python object of class \code{SpecialOrthogonal}. Defaults to
\code{NULL} in which case it is instantiated on the fly using the other input
arguments.}
}
\value{
An object of class \code{\link{SpecialOrthogonal}} which is an instance of one
of three different \code{\link[R6:R6Class]{R6::R6Class}} depending on the values of the input
arguments. Specifically:
\itemize{
\item if \code{n == 2} and \code{point_type == "vector"}, then the user wants to
instantiate the space of 2D rotations in vector representations and thus the
output is an instance of the \code{\link{SpecialOrthogonal2Vectors}} class;
\item if \code{n == 3} and \code{point_type == "vector"}, then the user wants to
instantiate the space of 3D rotations in vector representations and thus the
output is an instance of the \code{\link{SpecialOrthogonal3Vectors}} class;
\item in all other cases, either the user is dealing with rotations in matrix
representation or with rotations in dimension greater than 3 and thus the
output is an instance of the \code{\link{SpecialOrthogonalMatrices}} class.
}
}
\description{
This function generates an instance of the class for the special orthogonal
group \eqn{\mathrm{SO}(n)}.
}
\examples{
if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3
}
}
\seealso{
Other special orthogonal classes: 
\code{\link{SpecialOrthogonal2Vectors}},
\code{\link{SpecialOrthogonal3Vectors}},
\code{\link{SpecialOrthogonalMatrices}}
}
\author{
Nicolas Guigui and Nina Miolane
}
\concept{special orthogonal classes}
