% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz_formatting.R
\name{extract_meta}
\alias{extract_meta}
\title{Extract meta fields from a tag}
\usage{
extract_meta(tags)
}
\arguments{
\item{tags}{A single tag or vector of tags to extract the fields from.}
}
\value{
A named vector indicating the field and entry associated with it.
}
\description{
Extract meta fields from a tag
}
\examples{
\dontrun{

### Simple example
tag <- "{quiz, id: quiz_name_here, attempts: 10}"

# Extract metadata tags
meta <- extract_meta(tag)

### Example using a file
quiz_path <- good_quiz_path()
quiz_lines <- readLines(quiz_path)

# Put this in a data.frame so we can identify the content
quiz_df <- parse_quiz_df(quiz_lines)

# Extract the tags
tags <- quiz_df \%>\%
  dplyr::filter(type == "tag") \%>\%
  dplyr::pull("original")

# Extract metadata tags
meta <- extract_meta(tags)
}
}
