% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_fields.R
\name{g_mink_cart}
\alias{g_mink_cart}
\alias{g_mink_sph}
\title{Minkowski metric tensor}
\usage{
g_mink_cart(n, coords = paste0("x", 1:n - 1))

g_mink_sph(n, coords = c("t", "r", paste0("ph", 1:(n - 2))))
}
\arguments{
\item{n}{The dimension of the metric tensor.}

\item{coords}{A character vector of coordinate names. The length needs
to match the tensor dimensions.}
}
\value{
The covariant metric tensor as array imputed with coordinate names.
}
\description{
\code{g_mink_cart()} provides the covariant metric tensor in \code{n} dimensions in
Cartesian coordinates with signature \eqn{(-1, 1, 1, ...)}{`c(-1, 1, 1, ...)`}.
\deqn{ds^2=-dx_0^2+\sum_{i=1}^{n-1} dx_i^2}
\code{g_mink_sph()} provides the same tensor where the spatial part uses spherical
coordinates.
\deqn{ds^2=-dt^2 + dr^2 + r^2 d\Omega^2}
}
\examples{
g_mink_cart(4)
g_mink_cart(4) \%_\% .(+i, +j)
g_mink_sph(4)
g_mink_sph(4) \%_\% .(+i, +j)
}
\seealso{
Wikipedia \href{https://en.wikipedia.org/wiki/Minkowski_space#Minkowski_metric}{Minkowski metric tensor}

Other metric tensors: 
\code{\link{g_eucl_cart}()},
\code{\link{g_sph}()},
\code{\link{g_ss}()},
\code{\link{metric_field}()}
}
\concept{metric tensors}
\concept{metric_tensors}
