% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_path.R
\name{update_path}
\alias{update_path}
\title{Update the path to the raw series file}
\usage{
update_path(ws_xml_path, raw_data_path, sap_xml_path, verbose = TRUE)
}
\arguments{
\item{ws_xml_path}{the path to the xml file of the workspace}

\item{raw_data_path}{the new path to the raw data}

\item{sap_xml_path}{the path (or just the filename) of the xml file of
SA-Processing containing the series (Optional).}

\item{verbose}{A boolean to print indications on the processing
status (optional and TRUE by default)}
}
\value{
the \code{workspace} ws_to augmented with series present in ws_from and
not already in ws_to
}
\description{
Function to update the path of the raw data file in a workspace.
This function works with .csv, .xls and .xlsx format.
}
\details{
Warning! Since version 1.2.0, this function updates the raw data path of ALL
SA-Items in a SA-Processing. Therefore, the only way to identify a specific
SA-Processing is to provide the path to the XML file (which is not obvious
when the SA-Processings have different names or indices to their position).

The argument \code{sap_xml_path} is optional.
If \code{sap_xml_path} is not supplied, all SA-Processing will be updated.

It's also important that the new data file has the same structure as the
previous file :
- same column names
- same column position
- same extension and format (.csv, .xls or .xlsx)
}
\examples{
library("RJDemetra")
new_dir <- tempdir()
ws_template_path <- file.path(system.file("extdata", package = "rjdworkspace"),
                         "WS")

# Moving the WS in a temporary environment
copy_ws(
    ws_name = "ws_example_path",
    from = ws_template_path,
    to = new_dir
)

# Moving the raw data in a temporary environment
data_path <- file.path(system.file("extdata", package = "rjdworkspace"),
                       "data_file.csv")
file.copy(
    from = data_path,
    to = new_dir
)

path_ws <- file.path(new_dir, "ws_example_path.xml")
new_raw_data_path <- file.path(new_dir, "data_file.csv")

update_path(
    ws_xml_path = path_ws,
    raw_data_path = new_raw_data_path,
    sap_xml_path = file.path(new_dir, "ws_example_path", "SAProcessing", "SAProcessing-1.xml"),
)
update_path(
    ws_xml_path = path_ws,
    raw_data_path = new_raw_data_path,
    sap_xml_path = "SAProcessing-1.xml",
)
update_path(
    ws_xml_path = path_ws,
    raw_data_path = new_raw_data_path
)
}
