% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximation.R
\name{MaxClique}
\alias{MaxClique}
\title{Solver for Largest Complete Subgroup (All Nodes Connected)}
\usage{
MaxClique(
  arcSources,
  arcTargets,
  numNodes,
  algorithm = "GrossoLocatelliPullanMc"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "GrossoLocatelliPullanMc".
GrossoLocatelliPullanMc is the default.}
}
\value{
A named list containing two entries: 1) "size": the clique size, and
  2) "members": the members of the clique.
}
\description{
Finds the largest complete subgraph (clique) in an undirected graph
via approximation algorithms for the maximal clique problem.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00194.html}.
}
