% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptation.R
\name{stochastic_approximation_scale_adapter}
\alias{stochastic_approximation_scale_adapter}
\title{Create object to adapt proposal scale to coerce average acceptance rate using
a Robbins and Monro (1951) scheme.}
\usage{
stochastic_approximation_scale_adapter(
  initial_scale = NULL,
  target_accept_prob = NULL,
  kappa = 0.6
)
}
\arguments{
\item{initial_scale}{Initial value to use for scale parameter. If not set
explicitly a proposal and dimension dependent default will be used.}

\item{target_accept_prob}{Target value for average accept probability for
chain. If not set a proposal dependent default will be used.}

\item{kappa}{Decay rate exponent in \verb{[0.5, 1]} for adaptation learning rate.}
}
\value{
List of functions with entries
\itemize{
\item \code{initialize}, a function for initializing adapter state and proposal
parameters at beginning of chain,
\item \code{update} a function for updating adapter state and proposal parameters on
each chain iteration,
\item \code{finalize} a function for performing any final updates to adapter state and
proposal parameters on completion of chain sampling (may be \code{NULL} if
unused).
\item \code{state} a zero-argument function for accessing current values of adapter
state variables.
}
}
\description{
When combined with \code{\link[=covariance_shape_adapter]{covariance_shape_adapter()}} corresponds to Algorithm 4 in
Andrieu and Thoms (2009).
}
\examples{
proposal <- barker_proposal()
adapter <- stochastic_approximation_scale_adapter(
  initial_scale = 1., target_accept_prob = 0.4
)
adapter$initialize(proposal, chain_state(c(0, 0)))
}
\references{
Andrieu, C., & Thoms, J. (2008). A tutorial on adaptive MCMC.
\emph{Statistics and Computing}, 18, 343-373.

Robbins, H., & Monro, S. (1951). A stochastic approximation
method. \emph{The Annals of Mathematical Statistics}, 400-407.
}
