% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_surv.R
\name{brm_surv}
\alias{brm_surv}
\title{Bayesian regression models using 'Stan' for survival time}
\usage{
brm_surv(
  time,
  cnsr,
  var,
  rvar,
  family = "exponential",
  random = "fixed",
  data,
  iter = 2000,
  warmup = 1000,
  seed = NA,
  chains = 4
)
}
\arguments{
\item{time}{name of time variable in data. Need to set character.}

\item{cnsr}{name of censor variable in data. Need to set character.}

\item{var}{vector of covariate names in data. Need to set character.}

\item{rvar}{name of random effect in data. Need to set character.}

\item{family}{A description of the response distribution and link function to be used in the model. 'exponential', 'Weibull', 'log-normal', and 'log-logistic' can be selected.}

\item{random}{A description of random effect. 'fixed', 'normal', and 'frailty' are available.}

\item{data}{An object of class data.frame (or one that can be coerced to that class) containing data of all variables used in the model.}

\item{iter}{Number of total iterations per chain (including warmup; defaults to 2000).}

\item{warmup}{A positive integer specifying number of warmup (aka burnin) iterations. This also specifies the number of iterations used for stepsize adaptation, so warmup draws should not be used for inference. The number of warmup should not be larger than iter and the default is iter/2.}

\item{seed}{The seed for random number generation to make results reproducible. If NA (the default), Stan will set the seed randomly.}

\item{chains}{Number of Markov chains (defaults to 4).}
}
\value{
A list of an object of class brmsfit or stanfit (see rstan and brms), sampling values from posterior distribution, leave-one-out cross-validation, and widely applicable information criterions.
}
\description{
A function of Bayesian regression models using stan for parametric survival time. Exponential, Weibull, log-normal, and log-logistic model with fixed-effect, random-effect and frailty-effect can be available.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
d <- data.frame(time=1:100,
      status=sample(0:1, size=100, replace=TRUE),
      arm=sample(c("t", "c"), size=100, replace=TRUE),
      sex=sample(1:2, size=100, replace=TRUE),
      district=sample(1:5, size=100, replace=TRUE)
    )
head(d)
fit_x_r <- brm_surv(time="time", cnsr="1-status",
                    var=c("factor(arm)", "factor(sex)"),
                    rvar="district", data=d,
                    family="Weibull", random="frailty"
                    )
fit_x_r$fit
fit_x_r$post_sample
fit_x_r$waic
fit_x_r$loo

\dontshow{\}) # examplesIf}
}
