% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmstpara.R
\name{rmstpara}
\alias{rmstpara}
\title{Restricted mean survival time via parametric models}
\usage{
rmstpara(
  tau,
  var,
  rvar = NA,
  shape = NA,
  sigma = NA,
  family = "exponential",
  random = "fixed"
)
}
\arguments{
\item{tau}{A value of pre-specified evaluation time point.}

\item{var}{A vector of covariate values.}

\item{rvar}{a vector of frailty effects. It is necessary when log-normal frailty and log-logistic frailty models.}

\item{shape}{a vector of shape parameters. It is necessary when Weibull and log-logistic models.}

\item{sigma}{a vector of standard error parameters. It is necessary when log-normal model.}

\item{family}{A description of the response distribution and link function to be used in the model. 'exponential', 'Weibull', 'log-normal', and 'log-logistic' can be selected.}

\item{random}{A description of random effect. 'fixed', 'normal', and 'frailty' are available.}
}
\value{
An object of class brmsfit or stanfit. See rstan and brms.
}
\description{
A function of calculating restricted mean survival time via parametric models. Exponential, Weibull, log-normal and log-logistic models are available.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
d <- data.frame(time=1:100,
      status=sample(0:1, size=100, replace=TRUE),
      arm=sample(c("t", "c"), size=100, replace=TRUE),
      sex=sample(1:2, size=100, replace=TRUE),
      district=sample(1:5, size=100, replace=TRUE)
    )
head(d)
fit_x_r <- brm_surv(time="time", cnsr="1-status",
                    var=c("factor(arm)", "factor(sex)"),
                    rvar="district", data=d,
                    family="Weibull", random="frailty")
fit_x_r$post_sample
ps_x_r<-fit_x_r$post_sample
rmst_x_r<-rmstpara(tau=100, var=ps_x_r[,"b_intercept"]+ps_x_r[,"b_factor(arm)"],
                   shape=ps_x_r[,"shape"], rvar=ps_x_r[,"sd_district"],
                   family="Weibull",random="frailty")
rmst_x_r

\dontshow{\}) # examplesIf}
}
