% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robregcc.R
\name{classo_path}
\alias{classo_path}
\title{Compute solution path of constrained lasso.}
\usage{
classo_path(Xt, y, C, we = NULL, control = list())
}
\arguments{
\item{Xt}{CLR transformed predictor matrix.}

\item{y}{model response vector}

\item{C}{sub-compositional matrix}

\item{we}{specify weight of model parameter}

\item{control}{a list of internal parameters controlling the model fitting}
}
\value{
\item{betapath}{solution path estimate}
  \item{beta}{model parameter estimate}
}
\description{
The model uses scaled lasoo approach for model selection.
}
\examples{
library(robregcc)
library(magrittr)

data(simulate_robregcc)
X <- simulate_robregcc$X;
y <- simulate_robregcc$y
C <- simulate_robregcc$C
n <- nrow(X); p <- ncol(X); k <-  nrow(C)


#
Xt <- cbind(1,X)                         # accounting for intercept in predictor
C <- cbind(0,C)                           # accounting for intercept in constraint
bw <- c(0,rep(1,p))                       # weight matrix to not penalize intercept 

# Non-robust regression
control <- robregcc_option(maxiter = 5000, tol = 1e-7, lminfac = 1e-12)
fit.path <- classo_path(Xt, y, C, we = bw, control = control)
}
