% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{rockr.file_upload}
\alias{rockr.file_upload}
\title{Upload a file}
\usage{
rockr.file_upload(
  conn,
  source,
  destination = NULL,
  overwrite = FALSE,
  temp = FALSE
)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{source}{Path to the file in the local file system.}

\item{destination}{Path of the destination file in the Rocker R session. Root folder is the session's home or temporary folder (see 'temp' parameter).
If empty (default behavior), the destination file name will be the same as the source one.}

\item{overwrite}{Overwrite the destination file if TRUE. Default is FALSE.}

\item{temp}{Logical to specify whether the root folder is the R session's home or the temporary folder. Default is FALSE.}
}
\value{
Void
}
\description{
Upload a file into the Rocker R session working directory.
}
\examples{
\dontrun{
conn <- rockr.connect(username='user', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.open(conn)
# upload a file
rockr.file_upload(conn, 'data.csv')
# download, create destination folder and rename file
rockr.file_upload(conn, 'DatabaseTest.sav', '/spss/test.sav')
# upload a folder
rockr.file_upload(conn, 'input')
rockr.close(conn)
}
}
\seealso{
Other file functions: 
\code{\link{rockr.file_download}()}
}
\concept{file functions}
