% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ft_num}
\alias{ft_num}
\title{Mortality Reporting System with numerical measures}
\format{
A \code{tibble}.
}
\source{
\url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
}
\usage{
ft_num
}
\description{
Selection of 20 rows from the 122 Cities Mortality Reporting System. Measures
have been defined as integer values.
}
\details{
The original dataset covers from 1962 to 2016. For each week, in 122 US cities,
mortality figures by age group and cause, considered separately, are included.
In the cause, only a distinction is made between pneumonia or influenza and
others.
}
\examples{
# The operations to obtain it from the `ft` data set are:

ft_num <- ft |>
  dplyr::mutate(`Pneumonia and Influenza Deaths` = as.integer(`Pneumonia and Influenza Deaths`)) |>
  dplyr::mutate(`All Deaths` = as.integer(`All Deaths`))

}
\seealso{
\code{\link{mrs_cause_schema}}

Other mrs example data: 
\code{\link{ft}},
\code{\link{ft_age}},
\code{\link{ft_age_rpd}},
\code{\link{ft_cause_rpd}},
\code{\link{mrs_db}},
\code{\link{mrs_db_geo}},
\code{\link{mrs_ft}},
\code{\link{mrs_ft_new}}
}
\concept{mrs example data}
\keyword{datasets}
