#' rolr: A package for computing optimal three-group splits based on a
#' continuous covariate and a survival outcome using
#' ordered logrank tests (OLR)
#'
#' The rolr package provides three  main functions, \code{\link{rsolr12}},
#' \code{\link{rmolr}}, and \code{\link{rhier}}, for fast computation of
#' three-group optimal cutpoints using two simple OLR tests, a
#' modified OLR test, and a hierarchical method, respectively.
#' @author Pingping Qu and John Crowley
#' @references
#' Crowley J., Mitchell A., Qu P., Morgan G. and Barlogie B. Optimal three group
#' splits based on a survival outcome. In: Frontiers of Biostatistical Methods
#' and Applications in Clinical Oncology, 2017.
#'
#' Liu P. Y. and Tsai W. Y. A modified logrank test for censored survival data
#' under order restrictions. Statistics and probablility Letters 41:57-63, 1999.
#'
#' Liu P. Y., Tsai W. Y. and Wolf, M. Design and analysis for survival data
#' under order restrictions with a modified logrank test. Statistics in
#' medicine 17:1469-1479, 1998.
#'
#' Crowley J., LeBlanc M., Gentleman R. and Salmon, S. Exploratory methods in
#' survival analysis. In: IMS Laecture Notes 27:55-77, 1995.
#'
#' LeBlanc M. and Crowley J. Survival trees by goodness of split. Journal of
#' the American Statistical Association 88:457-467, 1993.
#'
#' Liu P. Y., Greeen S., Wolf M. and Crowley J. Testing against ordered
#' alternatives for censored survival data. Journal of the American Statistical
#' Association 88:163-160, 1993.
#'
#' Crowley J. Some extensions of the logrank test. In: Medical Informatics. D.
#' A. B. Lindberg and P. L. Reicherts, Eds. Lecture Notes 4:213-223, 1979.
#'
#' @docType package
#' @name rolr
NULL
