% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put_estimate.R
\name{put.estimate}
\alias{put.estimate}
\title{Option Greek and Estimated Premium of Put Option}
\usage{
put.estimate(s, k, t, sd, r, d = 0)
}
\arguments{
\item{s}{Spot Price of Underlying Asset}

\item{k}{Exercise Price of Contract}

\item{t}{Time to Expiration}

\item{sd}{Volatality}

\item{r}{Risk free rate of return}

\item{d}{Divident Yield (use cont.rate()), Default: 0}
}
\value{
Output gives the Option Greek of a Option Contract. Also the Premium of the contract is estimated.
}
\description{
Calculate the Option Greek of a Contract and Estimated Premium of Contract
}
\details{
"Greeks" is a term used in the options market to describe the different dimensions of risk involved in taking an options position. These Greeks are calculated in this function along with the premium of the option contract using the BSM Model.
}
\examples{
put.estimate(100, 105, 0.25, 0.35, 0.0488)
}
