% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factoranalysisjmv.h.R
\name{factorAnalysisjmv}
\alias{factorAnalysisjmv}
\title{Factor Analysis}
\usage{
factorAnalysisjmv(
  data,
  items,
  nFactorMethod = "eigen",
  nFactors = 1,
  minEigen = 1,
  extraction = "minres",
  rotation = "oblimin",
  colorLoadings = TRUE,
  screePlot = FALSE,
  eigen = FALSE,
  factorCor = FALSE,
  factorSummary = FALSE,
  modelFit = FALSE
)
}
\arguments{
\item{data}{the data as a data frame}

\item{items}{a vector of strings naming the variables of interest in
\code{data}}

\item{nFactorMethod}{.}

\item{nFactors}{.}

\item{minEigen}{.}

\item{extraction}{.}

\item{rotation}{.}

\item{colorLoadings}{.}

\item{screePlot}{.}

\item{eigen}{.}

\item{factorCor}{.}

\item{factorSummary}{.}

\item{modelFit}{.}
}
\value{
A results object containing:
\tabular{llllll}{
\code{results$loadings} \tab \tab \tab \tab \tab a html \cr
\code{results$factorStats$factorSummary} \tab \tab \tab \tab \tab a table \cr
\code{results$factorStats$factorCor} \tab \tab \tab \tab \tab a table \cr
\code{results$modelFit$fit} \tab \tab \tab \tab \tab a table \cr
\code{results$eigen$initEigen} \tab \tab \tab \tab \tab a table \cr
\code{results$eigen$screePlot} \tab \tab \tab \tab \tab an image \cr
}
}
\description{
Factor Analysis
}
