% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roughsf.R
\name{roughsf}
\alias{roughsf}
\title{Create a rough map}
\usage{
roughsf(
  layers,
  roughness = 1,
  bowing = 1,
  simplification = 1,
  font = "30px Arial",
  title = NULL,
  title_font = "30px Arial",
  caption = NULL,
  caption_font = "30px Arial",
  width = NULL,
  height = NULL,
  elementId = NULL,
  chunk_name = "canvas"
)
}
\arguments{
\item{layers}{an sf object or a list of sf object. each object should only contain one type of geometry.}

\item{roughness}{numeric vector for roughness of lines}

\item{bowing}{numeric vector for bowing of lines}

\item{simplification}{simplify drawings (remove points from objects)}

\item{font}{font size and font family for labels}

\item{title}{optional title of the map}

\item{title_font}{font size and font family for title}

\item{caption}{optional caption of the map}

\item{caption_font}{font size and font family for caption}

\item{width}{width}

\item{height}{height}

\item{elementId}{DOM id}

\item{chunk_name}{markdown specific}
}
\value{
htmlwidget containing the drawn network
}
\description{
plot a sf map using rough.js
}
\details{
The following attributes are supported for POLYGONS:
\itemize{
\item \emph{fill} fill color
\item \emph{color} stroke color
\item \emph{stroke} stroke size
\item \emph{fillstyle} one of "hachure", "solid", "zigzag", "cross-hatch", "dots", "dashed", "zigzag-line"
\item \emph{fillweight} thickness of fillstyle (between 0 and 1)
\item \emph{hachureangle} angle of hachure lines
\item \emph{hachuregap} gap between two hachure lines
}

The following attributes are supported for LINESTRINGS:
\itemize{
\item \emph{color} stroke color
\item \emph{stroke} stroke size
}

The following attributes are supported for POINTS:
\itemize{
\item \emph{color} color of point
\item \emph{size} size of point
\item \emph{label} label to be added (optional)
\item \emph{label_pos} position of label relative to point: (c)enter, (n)orth, (e)ast, (s)outh, (w)est (optional)
}

Default values are used if one of the attributes is not found.

The result of a roughsf call can be printed to file with \code{save_roughsf()}
}
\examples{
library(sf)
demo(nc, ask = FALSE, echo = FALSE)
nc_poly <- st_cast(nc,"POLYGON",warn = FALSE)
roughsf(nc_poly)
}
\references{
More details on roughjs can be found on https://github.com/rough-stuff/rough/wiki
}
