% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert}
\alias{convert}
\title{Convert \code{roxygen2} tags to \code{roxytypes} tags}
\usage{
convert(
  path = ".",
  format = config(path, refresh = TRUE, cache = FALSE)$format,
  ...,
  unmatched = FALSE,
  verbose = interactive()
)
}
\arguments{
\item{path}{(\code{character[1]}) A file path within your package. Defaults to the current working directory.}

\item{format}{(\code{character[1]}) A \code{glue}-style format to use to parse types and descriptions for conversion
to \code{roxytypes} tags. Available \code{glue} keywords include \code{type} and
\code{description}. By default, \code{type} will match any string until a closing
backtick and \code{description} will match any string. See details for more
information.}

\item{...}{Additional arguments passed to \code{\link[=build_format_regex]{build_format_regex()}}.}

\item{unmatched}{(\code{logical[1]}) Indicates whether tags that fail to match should still be converted into
\code{roxytypes} tags. Such conversions may be convenient if you aim to convert
your package holistically, as it will help to flag undocumented parameter
types the next time you re-build your documentation.}

\item{verbose}{(\code{logical[1]}) Indicates whether command-line interface should be emitted so that changes
can be reviewed interactively.}
}
\value{
(\code{logical[1]}) \code{TRUE} if successfully completes, \code{FALSE} if aborted. Always returns
invisibly.
}
\description{
Convert a package codebase into applicable \code{roxytypes} tags. For \code{roxygen2}
tags with drop-in replacements (namely \verb{@param} and \verb{@return} tags), process
descriptions and replace tags with \code{roxytypes} equivalents.
}
\details{
A format string is built using \code{\link[=build_format_regex]{build_format_regex()}}, which accepts
parameters \code{type} and \code{description}, which describe how to match these
components of a parameter definition. They are combined with the literal
content of \code{format} to produce a regular expression to split existing
definitions.

For comprehensive control, pass \code{format_re} directly, bypassing expression
construction altogether.
}
\examples{
\dontrun{
convert("(`{type}`) {description}")
}

}
