% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XXt_compute.R
\name{XXt.compute}
\alias{XXt.compute}
\title{XXt Computation}
\usage{
XXt.compute(
  X,
  meanX = NULL,
  varX = NULL,
  ncores = 4,
  check = TRUE,
  chunksize = 1000
)
}
\arguments{
\item{X}{The input matrix of type `matrix' or `dgCMatrix'. No
need to center or scale X as that would be done implicitly.}

\item{meanX}{Vector of column means of X. Will be computed if not provided.}

\item{varX}{Vector of column variances of X. Will be computed if not provided.}

\item{ncores}{the number of cores to be used. Default is 1.}

\item{check}{check for zero variances.}

\item{chunksize}{When using openmp parallelization, this would be the chunk
size under a dynamic scheduling.}
}
\value{
a nrow(X) x nrow(X) dense symmetric matrix.
}
\description{
For an input matrix X, This function computes UU' = tcrossprod(U)
where U = scale(X) in a memory efficient way.
}
\examples{
require("Matrix")
set.seed(123)
x <- rsparsematrix(100,100,density = 0.3)
norm(XXt.compute(x) - tcrossprod(scale(x))) # (4.783951e-13 on my machine)

}
\author{
Somak Dutta

Maintainer: Somak Dutta <somakd@iastate.edu>
}
