% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eBIC.R
\name{eBIC}
\alias{eBIC}
\title{Model selection using extended BIC}
\usage{
eBIC(rpc.obj)
}
\arguments{
\item{rpc.obj}{an object of class \code{rpc}, containing the following items: \cr
- X: matrix of covariates (excluding intercept) \cr
- y: response vector \cr
- rpc: vector of ridge partial correlation coefficients, one for each column in X. \cr}
}
\value{
BIC.PATH vector of eBIC of each model, starting with the intercept only model.

model.best sorted indices (in increased order) of the model with the smallest EBIC
}
\description{
This function performs model selection using extended BIC and the ridge partial correlation coefficients
}
\examples{
n <- 50; p <- 400;
trueidx <- 1:3
truebeta <- c(4,5,6)
X <- matrix(rnorm(n*p), n, p) # n x p covariate matrix
y <- 0.5 + X[,trueidx] \%*\% truebeta + rnorm(n)
res <- rpc(X,y, lambda = 0.1, ncores = 1)
eBIC(res) # model.best: model selected by eBIC


}
\author{
An Nguyen

Somak Dutta

Maintainer: Somak Dutta <somakd@iastate.edu>
}
