% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{add_resample_id}
\alias{add_resample_id}
\title{Augment a data set with resampling identifiers}
\usage{
add_resample_id(.data, split, dots = FALSE)
}
\arguments{
\item{.data}{A data frame.}

\item{split}{A single \code{rset} object.}

\item{dots}{A single logical: should the id columns be prefixed with a "."
to avoid name conflicts with \code{.data}?}
}
\value{
An updated data frame.
}
\description{
For a data set, \code{add_resample_id()} will add at least one new column that
identifies which resample that the data came from. In most cases, a single
column is added but for some resampling methods, two or more are added.
}
\examples{
library(dplyr)

set.seed(363)
car_folds <- vfold_cv(mtcars, repeats = 3)

analysis(car_folds$splits[[1]]) |>
  add_resample_id(car_folds$splits[[1]]) |>
  head()

car_bt <- bootstraps(mtcars)

analysis(car_bt$splits[[1]]) |>
  add_resample_id(car_bt$splits[[1]]) |>
  head()
}
\seealso{
labels.rsplit
}
