% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.rstack}
\alias{as.rstack}
\title{Create an rstack pre-filled from a given input}
\usage{
as.rstack(x, ...)
}
\arguments{
\item{x}{input to convert to a stack.}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
a new rstack.
}
\description{
Creates a new rstack from a given input. Coerces input to a
list first using \code{as.list}, the element at \code{x[[1]]} becomes the top of the new rstack.
}
\details{
Runs in \eqn{O(N)} in the size of the input. Because data frames return a list of
columns when run through \code{as.list}, running \code{as.rstack} results in a stack of
columns, rather than a stack of rows.
}
\examples{
s <- as.rstack(1:20)
print(s)

s <- as.rstack(1:200000)
print(s)

## A stack with only 5 elements, one for each column
oops <- as.rstack(iris)
print(oops)
}
\seealso{
\code{\link{rstack}}.
}

