% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_link}
\alias{set_formatter_link}
\title{Set link formatter}
\usage{
set_formatter_link(
  widget,
  column,
  label_field = NULL,
  url_prefix = NULL,
  url = NULL,
  target = "_blank",
  hoz_align = "left"
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{label_field}{(character): Column to be used as label for the link.}

\item{url_prefix}{(character): Prefix to add to the URL value.}

\item{url}{(JavaScript function): A JavaScript function that return the URL value.
The cell is passed to the function as its first argument.
Use \link[htmlwidgets]{JS} to pass JS code.}

\item{target}{(character): Target attribute of the anchor tag.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set link formatter
}
\examples{
data <- data.frame(
  label = c("This is a link", "This is another link"),
  link = c("https://eoda.de", "https://eoda.de/data-science"),
  link2 = c("eoda.de", "github.com"),
  link3 = c("guinan", "data-science")
)

js_func <- "(cell) => `https://eoda.de/${cell.getValue()}`"

tabulator(data) |>
  set_formatter_link("link", label_field = "label") |>
  set_formatter_link("link2", url_prefix = "https://") |>
  set_formatter_link("link3", url = htmlwidgets::JS(js_func), label_field = "label")
}
