% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtika.R
\docType{package}
\name{rtika}
\alias{rtika-package}
\alias{rtika}
\title{rtika: R Interface to 'Apache Tika'}
\description{
Extract text or metadata from over a thousand file types. Get either plain text or structured XHTML content.
}
\section{Installing}{


If you have not done so already, finish installing \pkg{rtika} by typing in the R console:

\code{install_tika()}
}

\section{Getting Started}{


The \code{\link{tika_text}} function will extract plain text from many types of documents. It is a good place to start. Please read the Vignette also.
Other main functions include \code{\link{tika_xml}} and \code{\link{tika_html}} that get a structured XHMTL rendition. The \code{\link{tika_json}} function gets metadata as `.json`, with XHMTL content. 

The \code{\link{tika_json_text}} function gets metadata as `.json`, with plain text content.

\code{\link{tika}} is the main function the others above inherit from. 
 
Use \code{\link{tika_fetch}} to download files with a file extension matching the Content-Type.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/rtika/}
  \item \url{https://github.com/ropensci/rtika/}
  \item Report bugs at \url{https://github.com/ropensci/rtika/issues/}
}

}
\author{
\strong{Maintainer}: Sasha Goodman \email{goodmansasha@gmail.com}

Authors:
\itemize{
  \item The Apache Software Foundation [copyright holder]
}

Other contributors:
\itemize{
  \item Julia Silge (Reviewed the package for rOpenSci, see https://github.com/ropensci/software-review/issues/191/) [reviewer]
  \item David Gohel (Reviewed the package for rOpenSci, see https://github.com/ropensci/software-review/issues/191/) [reviewer]
}

}
\keyword{internal}
