% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerMCFReader.R
\name{getBrukerMCFAllMetadata}
\alias{getBrukerMCFAllMetadata}
\title{Retrieve all metadata values from a Bruker MCF file}
\usage{
getBrukerMCFAllMetadata(reader, index)
}
\arguments{
\item{reader}{An RTMS reader object of class \code{rtmsBrukerMCFReader}}

\item{index}{A single numeric index specifying which acquisition the sample
set should be extracted from}
}
\value{
A data frame with all metadata parameters for the acquisition. The
data frame will have five columns: \code{Index}, the numeric index of the
acquisition; \code{PermanentName}, the internal identifier of the parameter in
Bruker software systems; \code{GroupName}, the group of parameters that each
value belongs to; \code{DisplayName}, the string used to specify the parameter to
users (i.e. how the parameter would be labelled in a user interface); and
\code{Value}, a character column containing the value of each metadata parameter.
Numeric quantities will also be returned as strings, with units if
appropriate.
}
\description{
Retrieves a table of all metadata values (including instrument data,
acquisition parameters, processing and analysis directives, etc.) for a
specific acquisition from a Bruker multi-acquisition MCF directory
(represented by an \code{rtmsBrukerMCFReader} object).
}
