% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussfit.R
\name{gauss2func}
\alias{gauss2func}
\title{Two Gaussian Absorption Features}
\usage{
gauss2func(x, a1, a2, mu1, mu2, sig1, sig2)
}
\arguments{
\item{x}{the vector of values at which to evaluate}

\item{a1}{the amplitude of the first feature}

\item{a2}{the amplitude of the second feature}

\item{mu1}{the center of the first feature}

\item{mu2}{the center of the second feature}

\item{sig1}{the spread of the first feature (must be greater than 0)}

\item{sig2}{the spread of the second feature (must be greater than 0)}
}
\value{
vector of values of the two specified inverted Gaussians
}
\description{
This function returns two Gaussian absorption features, both with continuum
1.0 and each with a specified amplitude, center, and spread.
}
\examples{
x = seq(5000, 5003, length.out=200)
y = gauss2func(x, 0.3, 0.5, 5001.5, 5002, 0.1, 0.1)
plot(x, y)

}
