% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWT2_TI.R
\name{IWT2_TI}
\alias{IWT2_TI}
\title{Invert 2-d Translation Invariant Wavelet Transform}
\usage{
IWT2_TI(tiwt, L, qmf)
}
\arguments{
\item{tiwt}{translation-invariant wavelet transform table, (3(J-L)+1)n by n.}

\item{L}{degree of coarsest scale.}

\item{qmf}{orthonormal quadrature mirror filter.}
}
\value{
\code{x} 2-d image reconstructed from translation-invariant transform TIWT.
}
\description{
Invert 2-d Translation Invariant Wavelet Transform
}
\examples{
x <- matrix(rnorm(2^2), ncol=2)
L <- 0
qmf <- MakeONFilter('Haar')
TIWT <- FWT2_TI(x, L, qmf)
xr <- IWT2_TI(TIWT,L,qmf)
}
