% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zentra.R
\name{zc_settings}
\alias{zc_settings}
\alias{zc_statuses}
\alias{zc_readings}
\title{retrieve settings of a device}
\usage{
zc_settings(token = NULL, sn = NULL, start_time = NULL, end_time = NULL)

zc_statuses(token = NULL, sn = NULL, start_time = NULL, end_time = NULL)

zc_readings(token = NULL, sn = NULL, start_time = NULL, start_mrid = NULL)
}
\arguments{
\item{token}{(required) authorization token as returned by \link{zc_token}}

\item{sn}{(required) the serial number for the device}

\item{start_time}{Return data with timestamps greater or equal start_time.
Specify start_time in UTC seconds, e.g.
1579474800)`}

\item{end_time}{Return data with timestamps smaller or equal end_time.
Specify end_time in UTC seconds, , e.g.
1579474800))`}

\item{start_mrid}{Return data with mrids greater or equal start_mrid.
This can be user to query data that has not been received yet,
see \href{https://zentracloud.com/api/v1/guide#APIGuidelines}{guidelines}.}
}
\description{
retrieve settings of a device

retrieve statuses of a device

retrieve readings of a device
}
\examples{
\dontrun{
zc_settings(token = "yourtoken",
  sn = "z6-00033",
  start_time = as.numeric(as.POSIXct(Sys.Date(), origin = "1970-01-01")))
}
\dontrun{
zc_statuses("yourtoken", sn = "z6-00033",
  start_time = as.numeric(as.POSIXct(Sys.Date(), origin = "1970-01-01")))
}
\dontrun{
zc_readings("yourtoken", sn = "z6-00033",
  start_time = as.numeric(as.POSIXct(Sys.Date(), origin = "1970-01-01")))
}
}
