% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShiMalikSC.R
\name{ShiMalikSC}
\alias{ShiMalikSC}
\title{Bi-parted Spectral Clustering. Shi and Malik.}
\usage{
ShiMalikSC(W, flagDiagZero = FALSE, verbose = FALSE)
}
\arguments{
\item{W}{Gram Similarity Matrix.}

\item{flagDiagZero}{if True, Put zero on the similarity matrix W.}

\item{verbose}{To output the verbose in the terminal.}
}
\value{
returns a list containing the following elements:
\itemize{
 \item{cluster: }{a vector containing the cluster}
 \item{eigenVect: }{a vector containing the eigenvectors}
 \item{eigenVal: }{a vector containing the eigenvalues}
}
}
\description{
Bi-parted spectral clustering based on Shi and Malik algorithm, which separates the data into two distinct clusters
}
\examples{
### Example 1: 2 disks of the same size
n<-100 ; r1<-1
x<-(runif(n)-0.5)*2;
y<-(runif(n)-0.5)*2
keep1<-which((x*2+y*2)<(r1*2))
disk1<-data.frame(x+3*r1,y)[keep1,]
disk2 <-data.frame(x-3*r1,y)[keep1,]
sameTwoDisks <- rbind(disk1,disk2)
W <- compute.similarity.ZP(scale(sameTwoDisks))
res <- ShiMalikSC(W,flagDiagZero=TRUE,verbose=FALSE)
plot(sameTwoDisks, col = res$cluster)
plot(res$eigenVect[,1:2], col = res$cluster, main="spectral space",
     xlim=c(-1,1),ylim=c(-1,1)); points(0,0,pch='+');
plot(res$eigenVal, main="Laplacian eigenvalues",pch='+'); 

### Example 2: Speed and Stopping Distances of Cars
W <- compute.similarity.ZP(scale(iris[,-5]))
res <- ShiMalikSC(W,flagDiagZero=TRUE,verbose=TRUE)
plot(iris, col = res$cluster)
plot(res$eigenVect[,1:2], col = res$cluster, main="spectral space",
     xlim=c(-1,1),ylim=c(-1,1)); points(0,0,pch='+');
plot(res$eigenVal, main="Laplacian eigenvalues",pch='+'); 
}
\references{
Shi, J and Malik, J. (2000). Normalized cuts and image segmentation. In PAMI, Transactions on Pattern Analysis and Machine Intelligence, pages 888-905
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
