% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skpss_test.R
\name{skpss_test}
\alias{skpss_test}
\title{Simulate a KPSS Test to Assess Unit Root in a Time Series}
\usage{
skpss_test(x, lag_short = TRUE, n_sims = 1000, sim_hyp = "stationary")
}
\arguments{
\item{x}{a vector}

\item{lag_short}{logical, defaults to \code{TRUE}. If \code{TRUE}, the
"short-term" lag is used for the KPSS test. If \code{FALSE}, the
"long-term" lag is used. These lags are those suggested by Schwert (1989).}

\item{n_sims}{the number of simulations for calculating an interval or
distribution of test statistics for assessing stationarity or
non-stationarity. Defaults to 1,000.}

\item{sim_hyp}{can be either "stationary" or "nonstationary". If
"stationary" (default), the function runs KPSS tests on simulated stationary
(pure white noise) data. This allows the user to assess
compatibility/plausibility of the test statistic against a distribution of
test statistics that are known to be pure white noise (in expectation). If
"nonstationary", the simulations are conducted on two different random walks.
The "trend" test includes a level drawn from a Rademacher distribution with
a time trend of that level, divided by 10.}
}
\value{
\code{skpss_test()} returns a list of length 3. The first element
in the list is a matrix of eta statistics calculated by the test. The first
of those is the level statistic and the second of those is the trend
statistic. The second element is a data frame of the simulated eta statistics,
where the type of simulation (level, trend) is communicated in the \code{cat} column.
The third element contains some attributes about the procedure for
post-processing.
}
\description{
\code{skpss_test()} provides a simulation approach to assessing
unit root in a time series by way of KPSS test, first proposed by Kwiatkowski
et al. (1992). It takes a vector and extracts the residuals from two models to
assess stationarity around a level or trend, producing a KPSS test statistic
(eta). Rather than interpolate or approximate a \emph{p}-value, it simulates
some user-specified number of KPSS of either a known, stationary time series
(default) or a known, non-stationary time series matching the length of the
time series the user provides. This allows the user to make assessments of
non-stationarity or stationarity by way of simulation rather than
approximation from received critical values by way of various books/tables.
}
\details{
Recall that this procedure defaults from almost every other unit root test
by making stationarity a null hypothesis. Non-stationarity is the alternative
hypothesis.

As of writing, the default lags are those suggested by Schwert (1989) to
apply to the Bartlett kernel generating the KPSS test statistic (eta).

\pkg{aTSA} has a particularly interesting approach to this test that draws on
on insights seemingly proposed by Hobijn et al. (2004). Future updates may
include those, but this function, as is, performs calculations of eta
identical to what \pkg{tseries} or \pkg{urca} would produce. Right now,
I don't have the time or energy to get into the weeds of what Hobijn et al.
(2004) are doing or what \pkg{aTSA} is implementing, but it seems pretty cool.

This function removes missing values from the vector before calculating test
statistics.
}
\examples{

x <- USDSEK$close[1:500] # note: one missing obs here; becomes series of 499

skpss_test(x, n_sims = 25) # make it quick...


}
\references{
Hobijn, Bart, Philip Hans Franses, and Marius Ooms. 2004. "Generalizations of
the KPSS-test for Stationarity". \emph{Statistica Neerlandica} 58(4): 483--502.

Kwiatkowski, Denis, Peter C.B. Phillips, Peter Schmidt, and Yongcheol Shin.
1992. "Testing the Null Hypothesis of Stationarity Against the Alternative
of a Unit Root: How Sure Are We that Economic Time Series Have a Unit Root?"
\emph{Journal of Econometrics} 54(1-3): 159--78.
}
\author{
Steven V. Miller
}
