#' Synthetic Data for Small Area Estimation under Spatial Simultaneous Autoregressive (SAR) Model and Normal Distribution
#'
#' @description Synthetic data of 64 regions to simulate Small Area Estimation under Spatial SAR Model and Normal Distribution using Hierarchical Bayesian Method
#'
#' This data is generated by these following steps:
#'
#' \enumerate{
#'   \item Generate sampling random area effect \eqn{v = (I - \rho W)^{-1}u} with \eqn{u ~ N(0, I)}, \eqn{I} is an identity matrix, and \eqn{W} is proximity matrix. The auxiliary variables are generated by \eqn{x1 ~ U(0, 1)} and \eqn{x2 ~ N(10, 1)}. The parameters \eqn{\beta_{0}, \beta_{1}, \beta_{2}}{\beta0, \beta1, \beta2} are set as 1 and \eqn{\rho} as 0.7
#'   \item Generate variance of the direct estimators \eqn{\sigma^{2}_{e}}{\sigma2e} with \eqn{\sigma^{2}_{e} ~ InvGamma(a, b)}{\sigma2e ~ InvGamma(a, b)}. Sampling error \eqn{e} is generated by \eqn{e ~ N(0, \sigma^{2}_{e})}{e ~ N(0, \sigma2e)}
#'   \item Calculate \eqn{\mu = \beta_{0} + \beta_{1}x1 + \beta_{2}x2 + u}{\mu = \beta0 + \beta1x1 + \beta2x2 + u}. Calculate the direct estimators of \eqn{\mu}, i.e \eqn{y = \mu + e}
#'   \item Direct estimators \eqn{y}, auxiliary variables \eqn{x1, x2}, and variance of the direct estimators are combined in a data frame called \code{sp.norm}
#' }
#'
#' @usage data(sp.norm)
#'
#' @format A data frame with 64 observations on the following 4 variables:
#' \describe{
#'   \item{y}{Direct estimators for each region}
#'   \item{x1}{Auxiliary variable of x1}
#'   \item{x2}{Auxiliary variable of x2}
#'   \item{vardir}{Sampling variance of the direct estimators for each region}
#' }
#'
"sp.norm"
