% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixClaire.R
\name{matrixClaire}
\alias{matrixClaire}
\title{Matrix G in Newton Raphson method by Claire E.B.O.}
\usage{
matrixClaire(alpha, beta)
}
\arguments{
\item{alpha}{An alpha estimate value on iterating process}

\item{beta}{A beta estimate value on iterating process}
}
\value{
This function returns a value of matrix G.
}
\description{
Matrix G in Newton Raphson method by Claire E.B.O.
}
\examples{
## load dataset with no weight value
data(dataEB)
temp = pcapdir(dataEB[,-c(3)])

## estimates alpha and beta parameter
## in EB estimate with Moment method by J.N.K.Rao
temp1 = alphabetaEB(data.dir = temp$direst ,pcap = temp$pcap,
                      method = "rao", opt = "moment",
                      maxiter = 100,tol = 0.00001)

##calculates matrix G
matrixClaire(alpha = temp1$alpha_cap, beta = temp1$beta_cap)

}
