% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newtonRaphsonC.R
\name{newtonRaphsonC}
\alias{newtonRaphsonC}
\title{Estimates alpha and beta parameter with Newton Raphson method by Claire E.B.O.}
\usage{
newtonRaphsonC(data.dir, pcap, maxiter, tol)
}
\arguments{
\item{data.dir}{Direct estimates of the data from function pcapdir}

\item{pcap}{weighted sample mean and variance from function pcapdir}

\item{maxiter}{the Maximum iteration value}

\item{tol}{Tolerance error value in iteration}
}
\value{
This function returns a data frame with following objects :
\item{alpha_cap}{an alpha estimator by Newton Raphson method of Claire E.B.O.}
\item{beta_cap}{an beta estimator by Newton Raphson method of Claire E.B.O.}
}
\description{
Estimates alpha and beta parameter with Newton Raphson method by Claire E.B.O.
}
\examples{
## load dataset with no weight value
data(dataEB)
temp = pcapdir(dataEB[,-c(3)])
newtonRaphsonC(data.dir = temp$direst, pcap = temp$pcap,
 maxiter = 100, tol = 0.00001)

##load dataset with weight value
data(dataEB)
temp = pcapdir(dataEB[,-c(3)])
newtonRaphsonC(data.dir = temp$direst, pcap = temp$pcap,
 maxiter = 100, tol = 0.00001)

}
