% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebcov.R
\name{ebcov}
\alias{ebcov}
\title{EB Poisson-Gamma with Covariates}
\usage{
ebcov(formula, data, e)
}
\arguments{
\item{formula}{an object of class \code{\link[stats]{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted. The details of model specification are given under 'Details'.}

\item{data}{a mandatory data frame containing the variables in \code{formula} and \code{e}.}

\item{e}{a variable that contains the expected numbers of cases in each area.}
}
\value{
The function returns a list with the following objects:
\describe{
 \item{EB}{data frame with number of rows equal to number of areas containing the EB estimator. For domains with zero sample size, the EB estimators are based on the synthetic regression.}
 \item{Parameter}{ }
 \itemize{
   \item alpha: the scale parameter estimator in Gamma distribution
   \item v: the shape parameter estimator in Gamma distribution
 }
 \item{fit}{ }
 \itemize{
   \item Estimate: maximum likelihood estimator of the model parameters
   \item SE: asymptotic estimate of the standard error of the the parameters
   \item Z: the Z statistic of the asymptotic hypothesis test that the population value for the parameter is 0
   \item LCL: lower 95\% confidence interval for the parameter estimators
   \item UCL: upper 95\% confidence interval for the parameter estimators
 }
 \item{MSE.EB}{ }
 \itemize{
   \item method: Jackknife
   \item mse: the mean squared error estimator of the EB estimators
 }
 \item{direct}{ }
 \itemize{
   \item est: direct estimators for the response variable
   \item mse: the mean squared error estimator of the direct estimators
 }
}
}
\description{
This function gives the area level EB and MSE estimator based on Wakefield (2006) model and the refinement model by Kismiantini (2007).
}
\details{
A typical model has the form response ~ terms where the response is a vector with numeric data type and terms is a set(s) of auxiliary variables.

A formula has an implied intercept term. To remove this use either y ~ x - 1 or y ~ 0 + x. See \code{\link[stats]{formula}} for more details of allowed formulae.

The \code{formula} only accomodates variables with count data type and will be modeled using binomial negatif linear regression.
}
\examples{
#Load dataset
data(lip)

#Save output as an object
results <- ebcov(Y ~ AFF, lip, E)
results

}
\seealso{
\code{\link[COUNT]{ml.nb2}}, \code{\link[MASS]{glm.nb}},
}
