% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnocov.R
\name{ebnocov}
\alias{ebnocov}
\title{EB Poisson-Gamma without Covariates}
\usage{
ebnocov(y, data, e)
}
\arguments{
\item{y}{a response variable contains the numbers of cases in each area.}

\item{data}{a mandatory data frame containing the \code{y} and \code{e} variables.}

\item{e}{a variable that contains the expected numbers of cases in each area.}
}
\value{
The function returns a list with the following objects:
\describe{
 \item{EB}{data frame with number of rows equal to number of areas containing the EB estimator. For domains with zero sample size, the EB estimators are based on the synthetic regression.}
 \item{Parameters}{ }
 \itemize{
   \item alpha: the scale estimator in Gamma distribution
   \item v: the shape parameter estimator in Gamma distribution
 }
 \item{MSE.EB}{ }
 \itemize{
   \item method: Jackknife
   \item mse: the mean squared error estimator of the EB estimators
 }
 \item{direct}{ }
 \itemize{
   \item est: direct estimators for the response variable
   \item mse: the mean squared error estimator of the direct estimators
 }
}
}
\description{
This function gives the area level EB and MSE estimator based on Clayton & Kaldor (1987).
}
\details{
This function only accomodates variables with count data type.
}
\examples{
#Load dataset
data(lip)

#Save output as an object
results <- ebnocov(Y, lip, E)
results

}
