% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_rast.R
\name{dis_rast}
\alias{dis_rast}
\title{Distance Rasters from a List of Geographic Gazetteers}
\usage{
dis_rast(gaz, ras, buffer = NULL)
}
\arguments{
\item{gaz}{an object of the class \code{list}, including one or more
geographic gazetteers of the class \code{SpatVector}.}

\item{ras}{an object of the class \code{SpatRaster}. Defining the extent and
resolution of the distances rasters.}

\item{buffer}{numerical.  The size of the geographic buffer around the
extent of \code{ras} for the distance calculations in degrees, to account for
geographic structures neighbouring the study area (such as a road right
outside the study area) Default is to the resolution of \code{ras}.}
}
\value{
a \code{list} of \code{SpatRaster} objects of the same length as
\code{gaz}. The values in each raster correspond to the planar geographic
distance to the next feature in \code{gaz}, given the resolution of
\code{ras}
}
\description{
Creates a list of distances rasters based on a list of geographic
gazetteers, as SpatVector objects, and a template SpatRaster,
indicating the desired extent and resolution.
}
\note{
Check https://github.com/azizka/sampbias/wiki for a tutorial on
sampbias.
}
\examples{

#create raster for resolution and extent
ras <- terra::rast(terra::ext(-5,5,-4,4), res = 1)

#create point gazeteer
pts <- data.frame(long = runif(n = 5, min = -5, max = 5),
                  lat = runif(n = 5, min = -4, max = 4),
                  dat = rep("A", 5))

pts <- terra::vect(pts, geom = c("long", "lat"))

lin <- as.matrix(data.frame(long = seq(-5, 5, by = 1),
                  lat = rep(2, times = 11)))
lin <- terra::vect(lin, type = "line")

gaz <- list(point.structure = pts, lines.strucutre = lin)

out <- dis_rast(gaz, ras)

}
\seealso{
\code{\link{calculate_bias}}
}
\keyword{spatial}
