% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMHMMR.R
\docType{class}
\name{ModelMHMMR-class}
\alias{ModelMHMMR-class}
\alias{ModelMHMMR}
\title{A Reference Class which represents a fitted MHMMR model.}
\description{
ModelMHMMR represents an estimated MHMMR model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamMHMMR} object. It contains the estimated
values of the parameters.}

\item{\code{stat}}{A \link{StatMHMMR} object. It contains all the statistics
associated to the MHMMR model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("predicted", "filtered", "smoothed", "regressors",
  "loglikelihood"), ...)}}{Plot method.
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"predicted" = } Predicted time series and predicted
        regime probabilities (fields \code{predicted} and
        \code{predict_prob} of class \link{StatMHMMR}).
      \item \code{"filtered" = } Filtered time series and filtering
        regime probabilities (fields \code{filtered} and
        \code{filter_prob} of class \link{StatMHMMR}).
      \item \code{"smoothed" = } Smoothed time series, and
        segmentation (fields \code{smoothed} and \code{klas} of class
        \link{StatMHMMR}).
      \item \code{"regressors" = } Polynomial regression components
        (fields \code{regressors} and \code{tau_tk} of class
        \link{StatMHMMR}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatMHMMR}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}
By default, all the above graphs are produced.}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(multivtoydataset)

mhmmr <- emMHMMR(multivtoydataset$x, multivtoydataset[,c("y1", "y2", "y3")],
                 K = 5, p = 1, verbose = TRUE)

# mhmmr is a ModelMHMMR object. It contains some methods such as 'summary' and 'plot'
mhmmr$summary()
mhmmr$plot()

# mhmmr has also two fields, stat and param which are reference classes as well

# Log-likelihood:
mhmmr$stat$loglik

# Parameters of the polynomial regressions:
mhmmr$param$beta
}
\seealso{
\link{ParamMHMMR}, \link{StatMHMMR}
}
