% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanProfileDates.R
\name{scanProfileDates}
\alias{scanProfileDates}
\title{Read profile dates from prf/pro file}
\usage{
scanProfileDates(Filename, tz = "UTC")
}
\arguments{
\item{Filename}{filename}

\item{tz}{time zone (default = 'UTC')}
}
\value{
vector of as.POSIXct timestamps
}
\description{
Before reading entire SNOWPACK output it can be helpful to  scan the profile timestamps first
}
\examples{

## Path to example prf file
Filename <- system.file('extdata', 'example.prf', package = 'sarp.snowprofile')

## Scan dates in file
Dates <- scanProfileDates(Filename)
print(Dates)

}
\seealso{
\link{snowprofilePrf}, \link{snowprofilePro}
}
\author{
shorton
}
