% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsbweibull.r
\name{dsbweibull}
\alias{dsbweibull}
\title{Size biased Weibull probability density}
\usage{
dsbweibull(x, lmean, lshape, log = FALSE, xlog = FALSE)
}
\arguments{
\item{x}{A vector of positive numbers.}

\item{lmean}{The mean of the distribution on the log scale.}

\item{lshape}{The log shape parameter of the underlying Weibull distribution.}

\item{log}{A logical indicating whether to return log densities.}

\item{xlog}{A logical indicating whether to return densities for log
transformed data.}
}
\value{
A vector of probability densities.
}
\description{
Calculates size biased Weibull probability density - the underlying
Weibull probability density when the likelihood of recording an
observation is proportional to its value.
}
\examples{
  data(BCI_speed_data)
  agoutiData <- subset(BCI_speed_data, species=="agouti")
  dsbweibull(agoutiData$speed, 0, 0.1)
}
