% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.sbm.r
\name{hist.sbm}
\alias{hist.sbm}
\title{Plot size biased distribution}
\usage{
\method{hist}{sbm}(x, log = TRUE, add = FALSE, breaks = 20, lpar = list(col = "red"), ...)
}
\arguments{
\item{x}{A size biased model fit of class \code{\link{sbm}}.}

\item{log}{A logical specifying whether to plot the log transformed or
untransformed data distribution.}

\item{add}{A logical specifying whether to create a new plot, or add a
parametric distribution curve to an existing plot.}

\item{breaks}{Integer defining number of breaks when generating histogram
(passed to \code{\link{hist}}).}

\item{lpar}{A list of plotting parameters controlling appearance of the
density curve line (if present - passed to \code{\link{lines}}).}

\item{...}{Additional parameters passed to \code{plot}, including those
affecting histogram appearance.}
}
\value{
None.
}
\description{
Plots the frequency histogram of data from a size biased model, with
fitted parametric distribution line if the model is parametric without
covariates.
}
\examples{
  # Fit and plot log-normal and Weibull models
  data(BCI_speed_data)
  agoutiData <- subset(BCI_speed_data, species=="agouti")
  lmod <- sbm(speed~1, agoutiData, pdf="lnorm")
  wmod <- sbm(speed~1, agoutiData, pdf="weibull")
  hist(lmod, breaks = 40)
  hist(wmod, add=TRUE, lpar=list(col="blue"))
}
