% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_draws.R
\name{combine_draws}
\alias{combine_draws}
\title{Combine Lists of Draws From a Posterior Predictive Distribution}
\usage{
combine_draws(draws, r)
}
\arguments{
\item{draws}{A list of draws from a posterior predictive distribution}

\item{r}{Number of MCMC draws}
}
\value{
A matrix or data frame containing `R` randomly sampled rows 
        from the combined `betadraw` components.
}
\description{
\code{combine_draws} combines and resamples parameter draws returned from an MCMC algorithm.
}
\references{
Bumbaca, F. (Rico), Misra, S., & Rossi, P. E. (2020). Scalable Target Marketing: Distributed Markov Chain Monte Carlo for Bayesian Hierarchical Models. Journal of Marketing Research, 57(6), 999-1018.
}
\seealso{
\code{\link{rhierLinearMixtureParallel}}, 
\code{\link{rhierMnlRwMixtureParallel}}, 
\code{\link{rhierLinearDPParallel}}, 
\code{\link{rhierMnlDPParallel}}
}
\author{
Federico Bumbaca, Leeds School of Business, University of Colorado Boulder, \email{federico.bumbaca@colorado.edu}
}
