% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.defined_by_tcrit}
\alias{bursts.defined_by_tcrit}
\title{Divide a recording into bursts defined by a critical time.}
\usage{
bursts.defined_by_tcrit(segments, t_crit, units = "s")
}
\arguments{
\item{segments}{A segment or multiple segments with $states and $dwells.
NOTE: separate segments will remain split, regardless of why they were originally divided.}

\item{t_crit}{Critical time at which to divide bursts (in seconds by default)}

\item{units}{what unit the critical time is in ('s','ms','us', or 'ns')}
}
\value{
bursts. Which is a list of segments
starting and ending in 1 states (open dwell)
}
\description{
Split segment at long pauses, dividing the segment into multiple -shorter- segments (which are the bursts), Along with the interburst closings, which are referred to as "gaps". (Default time units are seconds)
}
\examples{

infile <- system.file("extdata", "example1_tac.evt", package = "scbursts")
transitions <- evt.read(infile)
dwells <- evt.to_dwells(transitions)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")

bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")
head(bursts[[1]])

}
