% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.modify_conductance}
\alias{bursts.modify_conductance}
\title{Transform the conductance states according to a user-defined function of conductance level.}
\usage{
bursts.modify_conductance(bursts, fun)
}
\arguments{
\item{bursts}{the list of segments}

\item{fun}{a function on conductance levels}
}
\value{
A modified copy of the original bursts
}
\description{
Transform the conductance states according to a user-defined function of conductance level.
}
\examples{

infile <- system.file("extdata", "example4.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

### Collapse into three subconductance states
fun <- function(amp) {
    if (amp < 0.3)
        return(0)
    else if (amp >= 0.3 && amp < 0.6)
        return(0.5)
    else
        return(1)
}

bursts_d <- bursts.modify_conductance(bursts, fun)

}
